function error = mispricing_index(c, index_structure, r_term)
% --------------------------------------------------------------------------------------------------
% Wrapper function that calculate the index pricing error (fixed leg - default leg). The first
% argument overwrites the coupon rate of the index structure in order to be able to apply
% Newton-Raphson to this function.
% --------------------------------------------------------------------------------------------------
% c                 ... index coupon rate
% index_structure   ... structure containing credit default swap details (see 'all_steps_in_a_row.m')
% r_term            ... zero coupon rates, matching the quarterly coupon payment dates
% --------------------------------------------------------------------------------------------------
% sample call: mispricing_index(200, index_test, repmat(0.05, 20, 1))
% --------------------------------------------------------------------------------------------------

index_structure.market_price = c;
error = value_fixed_leg_index(index_structure, r_term) - value_default_leg_index(index_structure, r_term);